

/*
Translate Rotate Gaussian Fitting

Function:		To translate and rotate a side-view square image and acquire axial Gaussian centers

Input: 			The side-view three-color image stack (one channel must be the giantin double-punctum image) must meet the below requirements. (1) The background is subtracted to zero. (2) The image is a square (40 x 40 pixels). (3) The trans-side of the Golgi is up. (4) Two giantin puncta are manually marked as two ROIs and added to the ROI Manager.

Output:			In Results Window, axial line intensity profile values are listed in row 0 - 39 (0 - 39 axial pixels with 0 at the top). Row 42 is the Gausian center position. Row 43 is the R^2 value of the Gaussian Fitting.

Usage:			Open the multi-color image stack. Select the giantin channel as the active window. Execute this macro. A window pops up to prompt the selection of the folder directory where processed images are saved.
				Processed image is saved with "TR" appended at the beginning of its file name. In addition, relevant information, file names, and folder paths of processed images are displayed in the "Log" window.
				
*/



macro "Square_Image_Gaussian_Fitting"
{



print("--------------------------------------------------------------------------------------------------------------------------");

folder_path=getDirectory("Choose a Directory")

run("Clear Results");
title=getTitle;



run("Properties...", "channels=3 slices=1 frames=1 unit=pixel pixel_width=1 pixel_height=1 voxel_depth=1");		

run("Set Measurements...", "center redirect=None decimal=4");
roiManager("Deselect");
roiManager("Measure");

x1=getResult("XM", 0);
y1=getResult("YM", 0);
x2=getResult("XM", 1);
y2=getResult("YM", 1);
print("x1= ", x1, "; y1= ", y1, "; x2= ", x2, "; y2= ", y2);

				

xc = (x1 + x2)/2;
yc = (y1 + y2)/2;

Image_h=getHeight();
x_shift=(Image_h/2)-xc;
y_shift=(Image_h/2)-yc;
print("x_shift= ", x_shift, "; y_shift= ", y_shift);


Angle=0-(57.2958*atan((y2-yc)/(x2-xc)));
print("Rotation angle (degree) = ", Angle);

getDimensions(width1, height1, channels, slice1, frame1);  

		
for (channel_num=1; channel_num<=channels; channel_num++)
	{
		selectWindow(title);
		Stack.setChannel(channel_num);
		run("Translate...", "x=&x_shift y=&y_shift interpolation=Bilinear");
		run("Rotate... ", "angle=&Angle grid=2 interpolation=Bilinear");
	}




selectWindow(title);
saveAs("Tiff", folder_path+"TR-"+title);  

print("The image file:  ", title);
print("The processed file is saved at = ", folder_path);


roiManager("Delete");					




image_title=getTitle;

run("Clear Results");

getDimensions(width1, height1, channels, slice1, frame1);  

x = Array.getSequence(40); 		
								
			
for (channel_num=1; channel_num<=channels; channel_num++)
	{
		selectWindow(image_title);
		Stack.setChannel(channel_num);
		y = newArray (40); 
		intensity = 0;
		for (i = 0; i < 40; i++)		
			{
			for(j=0; j<40; j++)
				{
				intensity = intensity + getPixel(j,i);
				}
			
			setResult(image_title+"-C"+channel_num, i, intensity);
			y[i] = intensity; 
			intensity = 0;
			}
	Fit.doFit("Gaussian", x, y);
	Fit.plot;


	setResult(image_title+"-C"+channel_num, 40, "-");			
	setResult(image_title+"-C"+channel_num, 41, Fit.p(2));		
	setResult(image_title+"-C"+channel_num, 42, Fit.rSquared);	

	print("C"+channel_num+" Gaussian center = ", Fit.p(2), "        R^2 = ", Fit.rSquared);				
																								

	
	}



}